# DeepSeek“金融朋友圈” 从“争先”到“恐后”，从“好用”到“用好”

截至2月11日，有北京银行、江苏银行、苏商银行、重庆农村商业银行等多家银行及国泰君安等头部券商“尝鲜”DeepSeek。恒生电子、金证股份、星环科技等金融科技服务公司的大模型服务也接入了DeepSeek。

通过部署DeepSeek，一些金融机构看到了AI支出“降本增效”的可能性。专家表示，DeepSeek的出现在通用大模型领域产生了很强的“鲇鱼效应”，但从“好用”到“用好”，仍面临数据安全、恶意训练、模型幻觉等挑战。

**争相接入DeepSeek**

日前，北京银行宣布全面启动“all in AI”战略，携手华为率先实现DeepSeek全栈国产化金融应用。江苏银行依托“智慧小苏”大语言模型服务平台，本地化部署微调DeepSeek-VL2多模态模型、轻量DeepSeek-R1推理模型，分别运用于智能合同质检和自动化估值对账场景。重庆农村商业银行借助腾讯云大模型知识引擎的能力，在企业微信上线基于DeepSeek模型的智能助手应用“AI小渝”。

据公开信息，接入DeepSeek的金融机构类型涵盖银行、证券、基金、非银行支付机构等。目前，多家银行已实现DeepSeek系列大模型本地化部署，应用场景包括智能合同管理、客服助手等。

作为最早一批本地化部署DeepSeek的非银行支付机构之一，移卡最初选择DeepSeek的原因就是“好用”，这也成为DeepSeek拥趸众多的主要原因。

移卡执行董事、CTO罗小辉表示，移卡在2024年初就本地化部署了DeepSeek coder，在此基础上，移卡开发了编码助手，其功能包括代码撰写、代码纠错等。“DeepSeek是目前开源最彻底的大模型厂商，性能和效率俱佳。”罗小辉坦言，移卡准备长期使用以DeepSeek为代表的开源大模型，逐步替换海外AI产品的大模型服务，这将在保证质量的前提下大大降低应用成本。

奇安信银行行业负责人徐懿巍认为，训练成本更低，性能更强，完全开源、支持免费商用等优势，使DeepSeek在垂直行业更容易落地。

对此，优智科技创始人兼CEO詹毅颇有感触。目前优智科技与中信建投等头部券商在大模型应用领域完成项目上线，正与数十家金融机构推进应用落地。其核心AI平台（智遇文档、智友Agent）已全面接入DeepSeek，为金融机构提供包括DeepSeek私有化部署在内的完整解决方案。与此同时，优智科技正在DeepSeek上持续训练面向金融场景的模型版本。

“如果用造车来类比的话，金融机构青睐更好用的大模型‘整车’，而DeepSeek提供了更好的引擎。”詹毅称，对大模型应用而言，2024年更多是头部机构积极推动大模型落地，2025年在DeepSeek的认知普及和更多金融标杆案例的推动下，中小机构大模型应用将提速，市场将大幅扩容。

“以往谈到大模型，金融机构的目标往往是‘争先’；如今更多是‘恐后’，思维方式发生了质变。”詹毅说。

**“鲇鱼效应”持续强化**

重金投入，产出未知，一直是影响金融机构大模型规模化投入的重要原因，而通过部署DeepSeek，不少金融机构看到了AI支出“降本增效”的可能性。

据悉，恒生电子、星环科技、金证股份等金融科技服务商的大模型服务正加速接入DeepSeek。例如，恒生大模型系列应用全面接入DeepSeek主流模型（DeepSeek-V3/DeepSeek-R1），覆盖金融投研、投顾、合规、运营、投行等核心业务场景；星环科技大模型运营管理平台Sophon LLMOps全面支持DeepSeek-R1全参版本及蒸馏版本，可用于智能投研与策略支持、智能运营与流程再造等智能金融场景。其测试数据也印证了这一趋势。

以恒生电子为例，实测数据显示，在金融高密度数据处理场景中，依托DeepSeek-R1的千亿级参数压缩和蒸馏技术，本地部署算力资源消耗降低50%；基于DeepSeek独创的MoE（混合专家）架构，客户需求解析速度加快3倍。

“在一些强推理的业务场景，DeepSeek提升了训练实效。”星环科技金融行业助理副总裁张晓明近期在与客户的对接测试中发现，一些有大模型应用基础、算力和人才资源储备的银行和头部券商正积极接入DeepSeek，DeepSeek在通用大模型领域产生了很强的“鲇鱼效应”。

当然，DeepSeek优势突出并不意味着其他大模型被放弃。张晓明坦言，整个大模型市场还是一个多元需求的市场，目前已有金融客户用星环科技大模型运营管理平台Sophon LLMOps适配了70多个主流模型，可适应不同业务场景的需求，“DeepSeek热浪下，应该思考如何将大模型转化为生产力”。

恒生电子首席科学家、恒生研究院院长白硕称，DeepSeek擅长慢思考，在需要快慢思考结合的具体应用场景中，通义千问和DeepSeek可以相得益彰，发挥更大的效果。

对于未来DeepSeek的应用场景，罗小辉提出了两方面设想：“一是面向企业内部员工的效率工具；二是面向用户或客户的产品开发。”在应用模式上，除当作问答助手外，将大模型植入具体的应用场景能让其发挥更大的作用。

**不容忽视的挑战**

新生事物都是机遇和挑战并存，DeepSeek应用也不例外。专家表示，金融机构由于其业务性质，对数据的安全性、隐私保护及合规性有着极高要求，因此在部署大模型时也面临更大挑战。

徐懿巍表示，金融领域大模型往往包含复杂的算法和市场分析能力，开发成本较高，并承载重要业务和数据，自身安全性的重要性不言而喻。在OWASP发布的大模型应用十大安全风险中，“提示注入”位居首位。攻击者可通过设计特定的提示词来误导大模型产生错误的结果，特别是涉及投资决策、风险管理等关键领域时，这种攻击可能导致重大经济损失。

金融行业大模型的幻觉问题也是一大安全隐患。大模型生成的内容有时可能与现实不符，这对于高度依赖准确信息的金融行业来说，是一个潜在的风险，尤其在提供市场预测、风险评估或投资建议时，其危害不容忽视。

徐懿巍表示，金融机构在部署大模型时，安全风险不仅来自单个大模型服务，更来自整家公司。因此，金融企业要做好整个公司风险暴露面管理，实施严格的访问控制措施，如身份验证和授权机制，限制对API、数据库的访问。同时，做好网络、终端、云、服务器、数据库等基础网络安全防护措施，最大程度减少外部威胁。在具体保障措施方面，应围绕数据来源合规、内容安全合规、敏感数据识别过滤、训练数据标注安全、数据分类分级与安全保护、数据访问控制等，打造体系化的防护方案。

除安全外，基础设施特别是GPU资源也成为大模型部署的一大“掣肘”。“考虑到模型对于资源的需求较多，我们大多采用混合部署的方式，即部分本地化、部分外部接口的方式。我们正在密切关注大模型的小型化方案，期待通过这种方式来缓解资源压力，同时希望涌现更多GPU资源，本土大模型与计算设备的结合是接下来重点研究的事项。”罗小辉说。

张晓明建议，金融机构部署DeepSeek要综合考虑算力、预算和基础设施的投入情况，因“材”施策。“例如，中大型机构可通过部署R1全参版本，发挥算力、人才等综合优势，加速大模型的平台能力部署；中小机构可以立足业务导入蒸馏版，开发更适合DeepSeek落地的应用和工具，循序渐进，真正通过大模型实现降本增效。”张晓明说。

---
来源：中国经济网